# Macro definitions for SRPS -- the tutorial game system.

$$macro es(name, varname, base, class, cat, prereq)
{{
$$macrodesc(Easy skill macro)
$$argdesc(name, "Skill name")
$$argdesc(varname, "Variable name")
$$argdesc(base, "Base attribute (willpower, agility, etc.)")
$$argdesc(class, "Class of the skill (WM, AM, etc.)")
$$argdesc(cat, "Skill category")
$$argdesc(prereq, "Requirements for the skill")
	item "$(name)" cat "$(cat)" class $(class)
	checkexp c>0
	formula easy(~x,$(base))
	default $(base)-2 
	format %0ln%-5rc%-10rv%-16ll sformat %0ln%-5ll
	varname $(varname) level $(base)
	$$ifdef(prereq) prereq "$(prereq)" $$endif
}}


$$macro ms(name, varname, base, class, cat, prereq)
{{
$$macrodesc(Medium skill macro)
$$argdesc(name, "Skill name")
$$argdesc(varname, "Variable name")
$$argdesc(base, "Base attribute (willpower, agility, etc.)")
$$argdesc(class, "Class of the skill (WM, AM, etc.)")
$$argdesc(cat, "Skill category")
$$argdesc(prereq, "Requirements for the skill")
	item "$(name)" cat "$(cat)" class $(class)
	checkexp c>0
	formula medium(~x,$(base))
	format %0ln%-5rc%-10rv%-16ll sformat %0ln%-5ll
	default $(base)-3
	varname $(varname) level $(base)
	$$ifdef(prereq) prereq "$(prereq)" $$endif
}}


$$macro hs(name, varname, base, class, cat, prereq)
{{
$$macrodesc(Hard skill macro)
$$argdesc(name, "Skill name")
$$argdesc(varname, "Variable name")
$$argdesc(base, "Base attribute (willpower, agility, etc.)")
$$argdesc(class, "Class of the skill (WM, AM, etc.)")
$$argdesc(cat, "Skill category")
$$argdesc(prereq, "Requirements for the skill")
	item "$(name)" cat "$(cat)" class $(class)
	checkexp c>0
	formula hard(~x,$(base))
	format %0ln%-5rc%-10rv%-16ll sformat %0ln%-5ll
	varname $(varname) level $(base)
	$$ifdef(prereq) prereq "$(prereq)" $$endif
}}


$$macro espell(name, varname, base, class, cat, prereq)
{{
$$macrodesc(Easy spell macro)
$$argdesc(name, "Spell name")
$$argdesc(varname, "Variable name")
$$argdesc(base, "Base attribute (willpower, agility, etc.)")
$$argdesc(class, "Class of the skill (E, M, or H)")
$$argdesc(cat, "Skill category")
$$argdesc(prereq, "Requirements for the skill")
	item "$(name)" cat "$(cat)" class $(class)
	checkexp c>0
	formula easy(~x,$(base))
	format %0ln%-5rc%-10rv%-16ll sformat %0ln%-5ll
	varname $(varname) level $(base)
	$$ifdef(prereq) prereq "$(prereq)" $$endif
}}

# mspell = medium spell macro.

$$macro mspell(name, varname, base, class, cat, prereq)
{{
$$macrodesc(Medium spell macro)
$$argdesc(name, "Spell name")
$$argdesc(varname, "Variable name")
$$argdesc(base, "Base attribute (willpower, agility, etc.)")
$$argdesc(class, "Class of the skill (E, M, or H)")
$$argdesc(cat, "Skill category")
$$argdesc(prereq, "Requirements for the skill")
	item "$(name)" cat "$(cat)" class $(class)
	checkexp c>0
	formula medium(~x,$(base))
	format %0ln%-5rc%-10rv%-16ll sformat %0ln%-5ll
	varname $(varname) level $(base)
	$$ifdef(prereq) prereq "$(prereq)" $$endif
}}


# hspell = hard spell macro.

$$macro hspell(name, varname, base, class, cat, prereq)
{{
$$macrodesc(Hard spell macro)
$$argdesc(name, "Spell name")
$$argdesc(varname, "Variable name")
$$argdesc(base, "Base attribute (willpower, agility, etc.)")
$$argdesc(class, "Class of the skill (E, M, or H)")
$$argdesc(cat, "Skill category")
$$argdesc(prereq, "Requirements for the skill")
	item "$(name)" cat "$(cat)" class $(class)
	checkexp c>0
	formula hard(~x,$(base))
	format %0ln%-5rc%-10rv%-16ll sformat %0ln%-5ll
	varname $(varname) level $(base)
	$$ifdef(prereq) prereq "$(prereq)" $$endif
}}


$$macro cadv(name, cost, adj, cat, prereq)
{{
$$macrodesc(Constant-cost advantage)
$$argdesc(name, The advantage name)
$$argdesc(cost, Advantage point cost)
$$argdesc(adj, Adjustments)
$$argdesc(cat, Advantage category)
$$argdesc(prereq, Requirements)

	item "$(name)" cost $(cost) cat "$(cat)"
	editdlg	4
	$$ifdef(adj) adj $(adj) $$endif
	$$ifdef(prereq) prereq "$(prereq)" $$endif
}}


$$macro ladv(name, costlev, adj, limit, opttype, opt, optvalue)
{{
$$macrodesc(Level-based advantage)
$$argdesc(name, The advantage name)
$$argdesc(costlev, Cost per level)
$$argdesc(adj, Adjustments)
$$argdesc(limit, The maximum level the advantage may have)
$$argdesc(opttype, "The option type: text, adj, exp, etc. (optional)")
$$argdesc(opt, "The option name (optional, must be present if opttype specified)")
$$argdesc(optvalue, "The option value (optional, must be present if opttype specified)")

	item "$(name)" formula x*$(costlev)
	$$ifdef(limit) checkexp "x>0 and x<=$(limit)" $$else checkexp x>0 $$endif
	sformat "%0ln%-10r!$(costlev)/level" level 1 
	$$ifdef(adj) adj $(adj) $$endif
	$$ifdef(opttype) opt $(opttype) "$(opt)" "$(optvalue)" end $$endif
}}


$$macro armor(name, weight, price, defense)
{{
$$macrodesc(Armor macro)
$$argdesc(name, Armor name)
$$argdesc(weight, Weight of the armor)
$$argdesc(price, Price of the armor)
$$argdesc(defense, Armor defensive value)

	item "$(name)" cost $(weight)
	editdlg	4
	$$ifdef(price)
		format %0ln%-6rc%-15ro'Price'gp
		sformat %0ln%-6rc%-15ro'Price'gp
	$$else
		format %0ln%-6rc
		sformat %0ln%-6rc
	$$endif
	opt
		$$ifdef(price) adj Price totalprice+x $(price) $$endif
		$$ifdef(defense) adj Defense def+x $(defense) $$endif
		end
}}



$$macro weapon(name, weight, price, skill, dmgdice, sides, plusses, range)
{{
$$macrodesc(Weapon macro)
$$argdesc(name, Weapon name)
$$argdesc(weight, Weapon weight)
$$argdesc(price, "Weapon price (optional)")
$$argdesc(skill, Variable name for associated skill)
$$argdesc(dmgdice, Number of damage dice)
$$argdesc(sides, Sides on dice)
$$argdesc(plusses, Plusses on dice)
$$argdesc(range, "Weapon range (optional)")

	item "$(name)" cost $(weight)
	editdlg	4
	$$ifdef(price)
		format %0ln%-6rc%-15ro'Price'gp
		sformat %0ln%-6rc%-15ro'Price'gp
	$$else
		format %0ln%-6rc
		sformat %0ln%-6rc
	$$endif
	opt
		$$ifdef(price) adj Price totalprice+x $(price) $$endif
		$$ifdef(plusses) exp Damage "dmg($(dmgdice),$(sides),$(plusses)+`Damage Bonus`)" $$endif
		$$ifdef(skill) exp Skill "$(skill)+`To-hit Bonus`" $$endif
		$$ifdef(range) exp Range "$(range)" $$endif
		end
}}


$$macro equip(name, weight, price)
{{
$$macrodesc(Equipment macro)
$$argdesc(name, Equipment name)
$$argdesc(weight, Equipment weight)
$$argdesc(price, "Equipment price (optional)")

	item "$(name)" cost $(weight)
	editdlg	4
	$$ifdef(price)
		format %0ln%-6rc%-15ro'Price'gp
		sformat %0ln%-6rc%-15ro'Price'gp
	$$else
		format %0ln%-6rc
		sformat %0ln%-6rc
	$$endif
	opt
		$$ifdef(price) adj Price totalprice+x $(price) $$endif
		end
}}
